############################
##Lianne Ippel
##supplementary matrial for
##chapter 2: Basic introduction in R
##Rversion 3.0.2 
############################

## you can run this file by 'ctrl + r' or 'right click + run'

###################################################
## numbers and strings
###################################################
# an example of a numerical variable: 
x1 <- 10
x1

x1 + x1

# an example of a string variable: 
x2 <- '10'
x2

# this won't work: you cannot do computations with strings
x2 + x2

##logical expressions:
#equal to 
x1==10 

# smaller or equal 
x1 <= 5 

# larger
x1 > 5  

# unequal to
x1 != 5 

# an example of computations with booleans
# TRUE +1 = 2
(x1 == x1)+1 

###################################################
##storages
###################################################
## vector, c( )
x3 <- c(1,2, NA)
x3

#select: 
x3[2]

# add: 
x3[4] <- 4
x3

# this also works:
x3_new <- c(x3, 5)
x3_new

# a vector containing a sequence, is created using seq(from, to, by):
x4 <- seq(from = 1, to = 10, by = 2)
x4

# note a sequence with interval of 1:
x5 <- c(1:5)
x5

# a vector containing a series of repeated elements, rep(data, times, each)
x6 <- rep(1:2, times=3, each=2)
x6

## Matrix
x7 <- matrix(data = c(1:4), nrow = 2, ncol = 2)
x7

# [R] will fill up all cells, even though you have not giving it enough data 
x8 <- matrix(data = c(1:3), nrow = 3, ncol = 2)
x8

# select element:
x7[2,1]

# select row:
x7[2,]

# select column
x7[,2]

# add row 
x7_new_row <- rbind(x7, c(1,2))
x7_new_row 

# add column 
x7_new_column <- cbind(x7, c(5,6))
x7_new_column 

## Data frame
x9 <- data.frame(id=factor(c(1:3)), obs=c(10:12))
x9

# select element 
x9$id[2]
x9[x9$id==2,]

# select variable
x9$obs

# add variable
x9$new_var <- c(20:22)
x9


## array: array(data, dim = c(rows, columns, slices, etc.)) 
x10 <- array(data = c(1:4), dim = c(1, 3, 2))
x10

## list: list(cell 1, cell 2, cell 3, etc.)
x11 <- list(scalar=x1, vector=x3, array=x10, c(1,2))
x11
# select cell
x11$vector
x11[[1]]

#####################################################
##functions
#####################################################
multiplier <- function(input, times)
{
	local_result<- input*times
	return(local_result)
}

global_result <- multiplier(input=5, times=2)
global_result 

# note local_result is defined within the function therefore it doesn't exist globally:
local_result

##conditions: if statement
multiplier_not_zero<- function(input, times)
{
	local_result<- input*times
	if(local_result==0)
	{
		local_result<- 1
	}
	return(local_result)
}

multiplier_not_zero(input = 3, times = 0)

######################################################
##data: in and out
######################################################
#load *.txt file
my_dat1 <- read.table('directory/filename.txt',header, sep='')

#load *.RData file
my_dat2 <- load('directory/filename.RData')

#load *.csv file
my_dat3 <- read.csv('directory/filename.csv', header, sep='')

#save *.txt file
write.table('directory/filename.txt', header, sep='')

#save *.RData file
save('directory/filename.RData')

#save *.csv file
write.csv('directory/filename.csv', header, sep='')


#####################################################
##directory issues
##usually setting your directory is on of the first things you write in your script
#####################################################
#when you do not know in which directory you are working 
getwd()

#and when you want to change it you use
setwd('the/directory/you/want/to/work/in')

# this works as well
setwd('the\\directory\\you\\want\\to\\work\\in')

######################################################
##simulating data
######################################################
#when you want to make sure you get the same random numbers every single time:
#set the seed and run it together with the data generating function

set.seed(64568)
rnorm(n=3, mean=10, sd=2)

######################################################
##for loops
######################################################

row_average <- c()
for(i in 1 : nrow(x7))
{
	row_average[i] <- mean(x7[i,])
	print(row_average[i])
}

row_average

##alternatives
#rowMeans
(row_average <- rowMeans(x7)) # putting brackets around an assignment 
#tells [R] to print the object

## for the second alternative we need to install a package:
#####################################################
##packages
##usually this is the first or second part of your script
#####################################################
# installing packages, you can use single or double quotation marks
install.packages('plyr')

# after installing you have to attach them
library(plyr)

# example of one of plyr functions 
adply(.data=x7, .margins=1, .fun=mean)

#####################################################
##apply function
#####################################################

apply(x10, 1, mean)
apply(x10, 2, sum)
apply(x10, 3, FUN=function(x)
	{return(x*2)})
#####################################################
##Help function
##this you usually do in your console
#####################################################

#for information about a function:
?plot

#to search for the string "plot" in this case 
??plot

